// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : EntityThrownToken.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////


#include "EntityThrownToken.h"
#include "Level.h"
#include "Application.h"




EntityThrownToken::EntityThrownToken() :
  m_BounceCount( 0 )
{

  m_PickupDelay = 0.4f;
  m_CanBeCarried    = true;

  SetFrame( Dobbs::ANIM_TOKEN_ROTATE );

  SetRect( &m_CollisionRect, 0, 0, 32, 32 );

}



EntityThrownToken::~EntityThrownToken() 
{
}



void EntityThrownToken::OnEvent( const EntityEvent Event, int Param1, int Param2, const std::string& TextParam, Entity* pEntity )
{

  switch ( Event )
  {
    case EE_BLOCKED_LEFT:
      SetDirection( Dobbs::DIR_RIGHT );
      break;
    case EE_BLOCKED_RIGHT:
      SetDirection( Dobbs::DIR_LEFT );
      break;
    case EE_LAND:
      ++m_BounceCount;
      if ( m_BounceCount < 3 )
      {
        Jump( *m_pLevel, 250 );
      }
      g_App.PlaySound( "Icon.Bounce" );
      break;
  }
  Entity::OnEvent( Event, Param1, Param2, TextParam, pEntity );

}



void EntityThrownToken::UpdateTimed( Level& aLevel, float ElapsedTime )
{

  Entity::UpdateTimed( aLevel, ElapsedTime );

  if ( !HasLanded() )
  {
    if ( m_Direction == Dobbs::DIR_RIGHT )
    {
      Move( aLevel, 220.0f * ElapsedTime, 0.0f, Dobbs::DIR_RIGHT );
    }
    else if ( m_Direction == Dobbs::DIR_LEFT )
    {
      Move( aLevel, -220.0f * ElapsedTime, 0.0f, Dobbs::DIR_LEFT );
    }
  }

}



bool EntityThrownToken::HasLanded() const
{

  return m_BounceCount >= 3;

}